/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_3e_h__
#define __REG_3e_h__


/* ***********************************************************************
   *                                                                     *
   * regx3e.h                                                            *
   * Christoph Schmidt, BID R&D, 9.7.98                                  *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   ***********************************************************************
*/



#include "regxdir.h"   /* contains CMD_MERGE and CMDG_PROTOCOLSET_0 */


#define MERGE_TCSET_0(cmd)	CMD_MERGE (CMDG_TCSET_0, cmd)

#define CMDM_TCMASK_SET	0x05
#define CMD_TCMASK_SET		MERGE_TCSET_0 (CMDM_TCMASK_SET)
#define IN_TCMASK_SET		 6 /* Signaloffset (1), length (1) and value (4) */
#define OUT_TCMASK_SET		 0

#define CMDM_TCDEFSET	0x06
#define CMD_TCDEFSET		MERGE_TCSET_0 (CMDM_TCDEFSET)
#define IN_TCDEFSET		 0
#define OUT_TCDEFSET		 0

#define CMDM_TCPROP_SET	0x07
#define CMD_TCPROP_SET		MERGE_TCSET_0 (CMDM_TCPROP_SET)
#define IN_TCPROP_SET		 5
#define OUT_TCPROP_SET		 0

#define CMDM_TCPROP_PROG 0x08
#define CMD_TCPROP_PROG		MERGE_TCSET_0 (CMDM_TCPROP_PROG)
#define IN_TCPROP_PROG		 0
#define OUT_TCPROP_PROG		 0

#define CMDM_TCGENPROP_SET	0x09
#define CMD_TCGENPROP_SET	MERGE_TCSET_0 (CMDM_TCGENPROP_SET)
#define IN_TCGENPROP_SET        5
#define OUT_TCGENPROP_SET	0

#endif
